﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;

public class ProcessPlay : Process {

    public GameObject btMenu;
    public GameObject btcontinue;
    public GameObject btrestart;
    public GameObject btquit;
    public GameObject bigBossUI;
    public Image healthBar;


    // Use this for initialization
    public override void Init()
    {
        btMenu.SetActive(true);
        btquit.SetActive(false);
        btrestart.SetActive(false);
        btcontinue.SetActive(false);
        bigBossUI.SetActive(false);
        Score.tpsecoulé = 0.0f;
    }

    // Update is called once per frame
    void Update () {
        GameObject submarinePlayer = GameObject.Find("submarine(Clone)");
        GameObject BigBoss = GameObject.Find("BigBoss");
        if (BigBoss != null)
        {
            if ((submarinePlayer.transform.position - BigBoss.transform.position).magnitude < 750.0f)
            {
                bigBossUI.SetActive(true);
            }
            healthBar.transform.localScale = new Vector3(HealthBB.healthboss / 500, 1, 1);
            Debug.Log("Hbigboss =" + HealthBB.healthboss);
            Debug.Log(healthBar.transform.localScale);
            if (HealthBB.healthboss < 0)
            {
                bigBossUI.SetActive(false);
            }
        }
        

        Score.tpsecoulé += 1.0f * Time.deltaTime;

    }

    public void OnClickDie()
    {
        StateMachine.instance.SetState(STATE.GAMEOVER);
      
    }

    public void OnClickScore()
    {
        StateMachine.instance.SetState(STATE.SCORE);
       
    }

    public void OnClickRestart()
    {
        LoadLevel.instance.LoadLvl(LoadLevel.instance.currentLevel);
        Score.score = 0;
        Score.tpsecoulé = 0.0f;

    }

    public void OnClickQuit()
    {
        StateMachine.instance.SetState(STATE.SELECTLVL);
        LoadLevel.instance.currentLevel = 0;
        Destroy(LoadLevel.instance.parent);
        Destroy(LoadLevel.instance.parentsub);
    }

    public void OnClickMenu()
    {
        btMenu.SetActive(false);
        btquit.SetActive(true);
        btrestart.SetActive(true);
        btcontinue.SetActive(true);

    }

    public void OnClickContinue()
    {
        btMenu.SetActive(true);
        btquit.SetActive(false);
        btrestart.SetActive(false);
        btcontinue.SetActive(false);
    }
}
